#!/bin/csh -v

####################################################
#  Script to analyze scoring criteria for experimental phasing
#  T.Terwilliger   061008

echo "Running all scoring data for analysis of scoring"
date
echo "Data are in */*/run_052805a_scoring/PDS/AutoSol_run_1_/AutoSol_Facts_...dict"
echo "...Reading data"
# all solutions
./analyze_solutions_all_res.com >./analyze_solutions_all_res.log  
# output is all_res.dat  (all solutions, all data in text format)

# keep track of enantiomers
./analyze_solutions_hand.com >analyze_solutions_hand.log  
# output is hand.dat

echo "Analyzing scoring criteria ...."

#  Get all solutions in a simple list, keeping track of resolution
phenix.python analyze_solutions_asis_res.py no>analyze_solutions_asis_res.log
# output is raw_4_res.list

#  Get pairs of solutions that are enantiomers
phenix.python analyze_solutions_hand_2.py > analyze_solutions_hand_2.log

#  Test variables by themselves by constructing a Bayesian predictor and
#  then applying it (with jackknifing)
./run_bayes_jackknife_indiv.com >run_bayes_jackknife_indiv.log
foreach file (*_EST.list)
echo "$file `phenix.python get_cc.py $file `"
# output for variable (CORR_RMS) is bayes_5_est_CORR_RMS.dat
end

# Get the covariance of predictions from the 9 variables (no NCS_OVERLAP)
# requires jackknifed predictions above
phenix.python covariance.py > covariance.log

# Find out (after-the-fact) best combinations
foreach combo ( "SKEW" "SKEW CORR_RMS" )
echo "-----------------COMBO:  $combo -----------"
./run_bayes_jackknife_indiv_read.com $combo >run_bayes_jackknife_indiv_read.log
foreach file (*_combo_EST.list)
echo "$file `phenix.python get_cc.py $file `"
end
end

# get the best one specifically:
./run_bayes_jackknife_indiv_skew_corr_rms.com>run_bayes_jackknife_indiv_skew_corr_rms.log

#  Get the scoring histograms that we will use for real now
./get_scoring_hist.com > get_scoring_hist.log
# histogram is in scoring_hist.dat

echo "All done"
################################# 


