#!/bin/csh
echo "Getting basic data... only looking and inverse related pairs"
echo "" > hand.dat 
setenv working `pwd`
echo "Working directory: `pwd`"
set d = 052508a_scoring 
echo "Directory $d"
foreach dir (MAD/* MIR/* SAD1/* SAD2/* jcsg/*)
foreach chiral (jcsg/1vmg-dataset jcsg/2h9f-dataset jcsg/2re7-dataset jcsg/3b7f-dataset jcsg/2p8j-dataset jcsg/2pwn-dataset jcsg/2q9k-dataset jcsg/2qwz-dataset jcsg/2gc9-dataset jcsg/1vli-dataset jcsg/1vr8-dataset jcsg/2o3l-dataset jcsg/1vjr-dataset jcsg/1vr3-dataset jcsg/2fg0-dataset jcsg/2gpj-dataset jcsg/2oa2-dataset jcsg/2pv7-dataset jcsg/2qe9-dataset jcsg/2qml-dataset jcsg/2qw5-dataset jcsg/2r9v-dataset jcsg/3b8l-dataset jcsg/2evr-dataset jcsg/2ghr-dataset jcsg/2nuj-dataset jcsg/2g0t-dataset jcsg/2gvh-dataset jcsg/1vjf-dataset jcsg/1zbt-dataset jcsg/2fup-dataset jcsg/2hhz-dataset jcsg/2huh-dataset jcsg/2isb-dataset jcsg/2osd-dataset jcsg/2ql8-dataset jcsg/2qtp-dataset jcsg/2re3-dataset jcsg/2rha-dataset jcsg/2rkh-dataset jcsg/2go7-dataset jcsg/2h1q-dataset jcsg/2oaf-dataset jcsg/2own-dataset jcsg/1vk9-dataset jcsg/2od5-dataset jcsg/2r44-dataset jcsg/1zyb-dataset jcsg/2hh6-dataset jcsg/2ou6-dataset MAD/cp-synthase MAD/epsin MAD/group2-intron MAD/ic-lyase MAD/psd-95 MAD/synapsin MIR/qaprtase MIR/synaptotagmin SAD1/1102B SAD2/sec17)
if ($dir == $chiral)then
 echo "SKIPPING $dir"
 goto next
endif
end
cd $dir/run_$d
echo "DIR $dir/run_$d"
echo "DIR $dir/run_$d" >>$working/hand.dat
if (! -d AutoSol_run_1_ )mkdir AutoSol_run_1_
phenix.python $PHENIX/phenix/phenix/autosol/analyze_solutions_hand.py>>$working/hand.dat
next:
cd $working
end
