# THis one...all pairs of solutions in same run, compare delta perfect_cc with delta of scoring
# 070808 count number of correct decisions for |delta_cc|>0.05
"""
DIR MAD/aep/run_020208_scoring
Solution 2 AutoSol_run_1_ Z_SCORE: 431.8692 CC_TO_PERFECT: 0.6591
 NAME CC RFACTOR SKEW FOM NCS_OVERLAP
 RAW 0.6905 0.314 0.4314 0.78 1.077
 ZSCORE 100.3708 165.0859 96.964 15.6 53.8485
Solution 4 AutoSol_run_1_ Z_SCORE: 19.5832 CC_TO_PERFECT: 0.0365
 NAME CC RFACTOR SKEW FOM NCS_OVERLAP
 RAW 0.267 0.5769 0.0037 0.78 0.0
 ZSCORE 0.772 2.3374 0.8738 15.6 0.0
Solution 6 AutoSol_run_1_ Z_SCORE: 434.4561 CC_TO_PERFECT: 0.6591
 NAME CC RFACTOR SKEW FOM NCS_OVERLAP
 RAW 0.6923 0.3106 0.4314 0.78 1.078
 ZSCORE 100.7941 167.1953 96.9677 15.6 53.8991
"""
import sys,os
#
tolerance=0.05  # worth talking about
verbose=True
file="all_res_dm.dat"
print "Analyzing data in ",file
all_data_raw={}
all_data_z_score={}
all_data_overall_z={}
all_data_perfect_cc={}
score_type_list=[]
run_data={}
run_name=None
solution_name=None
solution_data={}

solution_name=None
types=None
raw_scores=None
z_scores=None

for line in open(file).readlines():
  if not line: continue
  if not line.split(): continue
  if line.split()[0]=="DIR" and len(line.split())>1:
     run_name=line.split()[1]
     #print "New run: ",run_name
     run_data_raw={}
     all_data_raw[run_name]=run_data_raw
     run_data_z_score={}
     all_data_z_score[run_name]=run_data_z_score
     run_data_overall_z={}
     all_data_overall_z[run_name]=run_data_overall_z
     run_data_perfect_cc={}
     all_data_perfect_cc[run_name]=run_data_perfect_cc

  elif  line.split()[0]=="Solution" and len(line.split())>1:
     solution_name=line.split()[1]
     try:
       solution_z_score=float(line.split()[4])
       solution_perfect_cc=float(line.split()[6])
     except:
       solution_z_score=None
       solution_perfect_cc=None

     #print "new solution: ",solution_name 
  elif  line.split()[0]=="NAME" and len(line.split())>1:
     types=line.split()[1:]
     if not score_type_list or len(score_type_list)<len(types):
          score_type_list=types
          print "SCORE TYPE LIST: ",score_type_list
  elif  line.split()[0]=="RAW" and len(line.split())>1:
     raw_scores=line.split()[1:]
  elif  line.split()[0]=="ZSCORE" and len(line.split())>1:
     z_scores=line.split()[1:]

  if solution_name and types and raw_scores and z_scores and\
       solution_z_score and solution_perfect_cc : # new solution
     solution_data_raw={}
     solution_data_z_score={}
     for type,raw_score,z_score in zip(types,raw_scores,z_scores):
       solution_data_raw[type]=raw_score
       solution_data_z_score[type]=z_score
     run_data_raw[solution_name]=solution_data_raw
     run_data_z_score[solution_name]=solution_data_z_score
     run_data_overall_z[solution_name]=solution_z_score
     run_data_perfect_cc[solution_name]=solution_perfect_cc
     solution_name=None
     types=None
     raw_scores=None
     z_scores=None

# analyze the data now:

run_list=all_data_raw.keys()
print "Total of ",len(run_list),"runs to analyze"

raw_out_3_dm=open('raw_3_dm.list','w')
zscore_out_3_dm=open('zscore_3_dm.list','w')
print >>raw_out_3_dm,"run solution other perfect_cc-perfect_cc_other",
for score_type in score_type_list:
  print >> raw_out_3_dm, score_type+"-"+score_type+"_other",
print >>raw_out_3_dm
print >>zscore_out_3_dm,"run solution other perfect_cc-perfect_cc_other zscore-zscore_other",
for score_type in score_type_list:
  print >> zscore_out_3_dm, score_type+"-"+score_type+"_other",
print >>zscore_out_3_dm

same={}
correct={}
incorrect={}
for score_type in score_type_list:
  same[score_type]=0
  correct[score_type]=0
  incorrect[score_type]=0

for run in run_list:
#for run in ['MIR/pen/run_020208b_scoring']:
  if verbose:print "\nRUN ",run
  solution_data_raw=all_data_raw[run]
  solution_data_z_score=all_data_z_score[run]
  solution_data_overall_z=all_data_overall_z[run]
  solution_data_perfect_cc=all_data_perfect_cc[run]
  solution_list=solution_data_raw.keys()
  used=[]
  for solution_test in solution_list:
   used.append(solution_test)
   for other_test in solution_list:
    if other_test in used: continue
    solution=solution_test
    other=other_test

    perfect_cc=solution_data_perfect_cc[solution]
    perfect_cc_other=solution_data_perfect_cc[other]
    if 0 and perfect_cc_other > perfect_cc:  # don't do this...keep 
      save=solution
      solution=other
      other=save
      perfect_cc=solution_data_perfect_cc[solution]
      perfect_cc_other=solution_data_perfect_cc[other]

    data_raw=solution_data_raw[solution]
    data_z_score=solution_data_z_score[solution]
    overall_z=float(solution_data_overall_z[solution])

    data_raw_other=solution_data_raw[other]
    data_z_score_other=solution_data_z_score[other]
    overall_z_other=float(solution_data_overall_z[other])

    delta=float(data_raw['FOM'])-float(data_raw_other['FOM'])
    #if delta<-0.01 or delta> 0.01: continue
    
    if verbose:print "\nSOLUTION ",solution," INVERSE: ",other,"Z:",overall_z," CC:",perfect_cc
    print >>raw_out_3_dm, run,solution,other,perfect_cc-perfect_cc_other,
    print >>zscore_out_3_dm, run,solution,other,perfect_cc-perfect_cc_other,overall_z-overall_z_other,
    
    for score_type in score_type_list:
       try:
         raw=float(data_raw[score_type])
         raw_other=float(data_raw_other[score_type])
       except: 
         raw=0.0
         raw_other=0.0
       try:
         delta=raw-raw_other
       except:
         delta=0.

       try:
         z_score=float(data_z_score[score_type])
         z_score_other=float(data_z_score_other[score_type])
       except: 
         z_score=0.0
         z_score_other=0.0
       try:
         delta_z=z_score-z_score_other
       except:
         delta_z=0.


       if verbose:print score_type,raw,raw_other,z_score,z_score_other
       print >>raw_out_3_dm, raw-raw_other,
       print >>zscore_out_3_dm, delta_z,

       # keep track of percentage correct decisions 070808
       delta_perf=perfect_cc-perfect_cc_other
       if delta_perf<0: delta_perf=-1.*delta_perf
       if delta_perf>tolerance:  # worth talking about
         if raw>raw_other:
           correct[score_type]+=1
         elif raw<raw_other:
           incorrect[score_type]+=1
         else:
           same[score_type]+=1
       else:
         same[score_type]+=1

    print >>raw_out_3_dm
    print >>zscore_out_3_dm

for score_type in score_type_list:
  total=correct[score_type]+incorrect[score_type]
  if total >0:
    corr=100.*float(correct[score_type])/float(total)
  else: corr=0.5
  print "Fraction correct choices: %s %6.2f %i %i %i" %(score_type,corr,correct[score_type],incorrect[score_type] ,same[score_type])

