from __future__ import division
from libtbx import easy_run

def run_polder(pdb_code, selection):
  cmd = " ".join([
    "phenix.polder",
    "%s.pdb" % pdb_code,
    "%s.mtz" % pdb_code,
    "sphere_radius=5",
    'output_file_name_prefix="%s" ' %pdb_code,
    'solvent_exclusion_mask_selection="%s" ' % selection,
    "debug=True",
    "> %s_polder.log" % pdb_code
  ])
  print cmd
  easy_run.call(cmd)

run_polder(
  pdb_code = '1f8t',
  selection = 'chain H and resseq 105')
