from __future__ import division
from libtbx import easy_run

def run_polder(pdb_code, selection):
  cmd = " ".join([
    "phenix.polder",
    "%s.pdb" % pdb_code,
    "%s.mtz" % pdb_code,
    "sphere_radius=5",
    'output_file_name_prefix="%s" ' %pdb_code,
    'solvent_exclusion_mask_selection="%s" ' % selection,
    "> %s_polder.log" % pdb_code
  ])
  print cmd
  easy_run.call(cmd)

def run_map_model_cc(pdb_code, selection, coefficients, maptype):
  cmd = " ".join([
    "phenix.get_cc_mtz_pdb",
    "%s.pdb" % pdb_code,
    "%s_polder_map_coeffs.mtz" % pdb_code,
    'atom_selection="%s" ' % selection,
    'labin="FP=%s PHIB=PHI%s"' % (coefficients, coefficients),
    "> %s_mapcc_%s.log" % (pdb_code, maptype)
  ])
  print cmd
  easy_run.call(cmd)


def run_stuff(pdb_code, selection):
  run_polder(
	pdb_code = pdb_code,
	selection = selection)
  run_map_model_cc(
	pdb_code = pdb_code,
	selection = selection,
	coefficients = 'mFo-DFc_polder',
	maptype = 'polder')
  run_map_model_cc(
	pdb_code = pdb_code,
	selection = selection,
	coefficients = 'mFo-DFc_omit',
	maptype = 'omit')

run_stuff(
	pdb_code = '4opi',
	selection = 'chain A and resseq 502')
run_stuff(
	pdb_code = '1aba',
	selection = 'chain A and resseq 88')
run_stuff(
	pdb_code = '1c2k',
	selection = 'chain A and resseq 246')

# command for grep
# grep -B1 'local CC' *mapcc*.log