#---------------
# load map and select
#---------------
load 1f8t.pdb
select H105, chain H and resi 105
select aroundH105, chain H and resi 103-107 
load 1f8t_H105.pdb
select H105_moved, 1f8t_H105 and chain H and resi 103-107
show sticks, aroundH105
hide lines
hide nonbonded,
bg_color white
center H105
#---------------
# map settings
#---------------
set mesh_width,0.35
set mesh_radius,0.001 #0.012
#---------------
# performance           
#---------------
set direct,1.
set orthoscopic,on
set ray_trace_fog_start,0.5
util.performance(0)
util.ray_shadows('light')
cmd.space('cmyk')
set antialias,on
#-------------------------
# load maps and draw mesh
#-------------------------
load 1f8t_polder_map_coeffs_1.ccp4
load 1f8t_polder_map_coeffs_2.ccp4
load 1f8t_map_coeffs_2mFo-DFc.ccp4
load 1f8t_map_coeffs_mFo-DFc.ccp4
# view
set_view (\
    -0.115482792,   -0.898529470,    0.423438400,\
    -0.901101351,   -0.084592871,   -0.425250918,\
     0.417925388,   -0.430673152,   -0.799909115,\
    -0.001544932,    0.000530742,  -27.043121338,\
    29.201988220,  -68.748245239,   39.754844666,\
    18.786207199,   35.249977112,  -20.000000000 )
#-----
isomesh omit, 1f8t_polder_map_coeffs_2, 3.0, H105, carve=8
isomesh omit_neg, 1f8t_polder_map_coeffs_2, -3.0, H105, carve=8
cmd.color(22,"omit")
cmd.color(4,"omit_neg")
ray
cmd.png('''/Users/dcliebschner/Desktop/figure7a.png''',quiet=0)
cmd.disable('omit')
cmd.disable('omit_neg')
#-----
isomesh 2fo, 1f8t_map_coeffs_2mFo-DFc, 1.0, aroundH105, carve=2.2
isomesh fofc, 1f8t_map_coeffs_mFo-DFc, 3.0, H105, carve=8
isomesh fofc_neg, 1f8t_map_coeffs_mFo-DFc,-3.0, H105, carve=8
cmd.color(4155,"2fo")
cmd.color(22,"fofc")
cmd.color(4,"fofc_neg")
ray
cmd.png('''/Users/dcliebschner/Desktop/figure7c.png''',quiet=0)
cmd.disable('2fo')
cmd.disable('fofc')
cmd.disable('fofc_neg')
cmd.disable('aroundH105')
#-----
hide sticks, aroundH105
show sticks, H105_moved
util.cba(33,"H105_moved",_self=cmd)
isomesh polder, 1f8t_polder_map_coeffs_1, 3.0, H105, carve=8
isomesh polder_neg, 1f8t_polder_map_coeffs_1, -3.0, H105, carve=8
cmd.color(22,"polder")
cmd.color(4,"polder_neg")
ray
cmd.png('''/Users/dcliebschner/Desktop/figure7b.png''',quiet=0)
cmd.disable('polder')
cmd.disable('polder_neg')
#isomesh omit_low, 1f8t_polder_map_coeffs_2, 2.0, H105, carve=8
#isomesh omit_low_neg, 1f8t_polder_map_coeffs_2, -1.5, H105, carve=8
#cmd.color(22,"omit_low")
#cmd.color(4,"omit_low_neg")
cmd.save('''/Users/dcliebschner/Desktop/figure7.pse''',quiet=0)
#-----------------
# get orientation
#-----------------
