from __future__ import division
from libtbx import easy_run

def run_polder(pdb_code, selection):
  cmd = " ".join([
    "phenix.polder",
    "%s.pdb" % pdb_code,
    "%s.mtz" % pdb_code,
    "sphere_radius=5",
    'output_file_name_prefix="%s" ' %pdb_code,
    'solvent_exclusion_mask_selection="%s" ' % selection,
    "> %s_polder.log" % pdb_code
  ])
  print cmd
  easy_run.call(cmd)

def run_maps(pdb_code):
  cmd = " ".join([
    "phenix.maps",
    "%s.pdb" % pdb_code,
    "%s.mtz" % pdb_code  
    ])
  print cmd
  easy_run.call(cmd)


run_polder(
	pdb_code = '1f8t',
	selection = 'chain H and resseq 105')

run_maps(pdb_code = '1f8t')

# phenix.mtz2maps 1f8t_polder_map_coeffs.mtz
# phenix.mtz2maps 1f8t_map_coeffs.mtz