#---------------
# load map and select
#---------------
load 1c2k.pdb
select ABI246, chain A and resi 246
show sticks
#show sticks, ABI246
hide lines
hide nonbonded,
bg_color white
center ABI246
select ZN, chain A and resi 258
show spheres,ZN
set sphere_scale, 0.5
select atom1, /1c2k//A/ABI`246/N3
select atom2, /1c2k//A/SER`195/OG
unbond zn, atom1
unbond zn, atom2

cmd.select('sele','none')
cmd.select('sele',"byresi((((sele) or byresi((1c2k`3009))) and not ((byresi((1c2k`3009))) and byresi(sele))))",enable=1)
cmd.select('sele',"byresi((((sele) or byresi((1c2k`587))) and not ((byresi((1c2k`587))) and byresi(sele))))",enable=1)
cmd.select('sele',"byresi((((sele) or byresi((1c2k`2875))) and not ((byresi((1c2k`2875))) and byresi(sele))))",enable=1)
cmd.hide("everything","sele")
#---------------
# map settings
#---------------
set mesh_width,0.35
set mesh_radius,0.001 #0.012
#---------------
# performance
#---------------
set direct,1.
set orthoscopic,on
set ray_trace_fog_start,0.5
util.performance(0)
util.ray_shadows('light')
cmd.space('cmyk')
set antialias,on
#-------------------------
# load maps and draw mesh
#-------------------------
load 1c2k_polder_map_coeffs_1.ccp4
load 1c2k_polder_map_coeffs_2.ccp4
set_view (\
     0.218583643,    0.422914088,   -0.879409909,\
    -0.579511821,    0.781327665,    0.231702462,\
     0.785097003,    0.458984494,    0.415872574,\
    -0.000343027,   -0.000197811,  -27.912319183,\
    44.628993988,   20.507074356,   51.180335999,\
    25.673885345,   30.168487549,  -20.000000000 )
isomesh polder, 1c2k_polder_map_coeffs_1, 3.0, ABI246, carve=8
isomesh polder_neg, 1c2k_polder_map_coeffs_1, -3.0, ABI246, carve=8
cmd.color(22,"polder")
cmd.color(4,"polder_neg")
ray
cmd.png('''/Users/dcliebschner/Desktop/figure6b.png''',quiet=0)
cmd.disable('polder')
cmd.disable('polder_neg')
#-----
isomesh omit, 1c2k_polder_map_coeffs_2, 3.0, ABI246, carve=8
isomesh omit_neg, 1c2k_polder_map_coeffs_2, -3.0, ABI246, carve=8
cmd.color(22,"omit")
cmd.color(4,"omit_neg")
ray
cmd.png('''/Users/dcliebschner/Desktop/figure6a.png''',quiet=0)
cmd.disable('omit')
cmd.disable('omit_neg')
#-----
isomesh omit_low, 1c2k_polder_map_coeffs_2, 2.1, ABI246, carve=8
isomesh omit_low_neg, 1c2k_polder_map_coeffs_2, -2.1, ABI246, carve=8
cmd.color(22,"omit_low")
cmd.color(4,"omit_low_neg")
ray
cmd.png('''/Users/dcliebschner/Desktop/figure6c.png''',quiet=0)
cmd.save('''/Users/dcliebschner/Desktop/figure6.pse''',quiet=0)

