gnuplot << eof
set term svg size 650,500 fname "Verdana" fsize 15 rounded dashed

# define axis
# remove border on top and right and set color to gray
set style line 11 lc rgb '#808080' lt 1
set border 3 back ls 11
set tics nomirror

# define grid
set style line 12 lc rgb '#808080' lt 0 lw 1
set grid back ls 12

# Remove border on top and right.  These borders are useless and
# make it harder to see plotted lines near the border.
# Also, put it in grey; no need for so much emphasis on a border.
#set xtics nomirror
#set ytics nomirror

#set log x
#set mxtics 10    # Makes logscale look good.

# Line styles: try to pick pleasing colors, rather
# than strictly primary colors or hard-to-see colors
# like gnuplot's default yellow.  Make the lines thick
# so they're easy to see in small plots in papers.
set style line 1 lt 1
set style line 2 lt 1
set style line 3 lt 1
set style line 4 lt 1
set style line 1 lt rgb "#FF6347" lw 3 #pt 5
set style line 2 lt rgb "#00FF7F" lw 3 #pt 9
set style line 3 lt rgb "#87CEEB" lw 3 #pt 5
set style line 4 lt rgb "#F4A460" lw 3 #pt 13
set style line 5 lt rgb "#7B68EE" lw 3
set style line 6 lt rgb "#00A000" lw 3

set output "r_reso.svg"
set xlabel "resolution (Å)" font "Verdana, 20"
set ylabel "R factor (%)" font "Verdana, 20"

#unset key
set key outside above #width 1

set xrange [9:1]
#set yrange [0:1]

#plot "template.dat" \
#   index 0 title "Example line" w lp ls 1, \
#"" index 1 title "Another example" w lp ls 2
plot 'data_r_reso_mod' \
     u 2:3 with lines ls 1 title 'bulk solvent', \
  '' u 5:6 with lines ls 2 title 'Babinet', \
  '' u 8:9 with lines ls 5 title 'no solvent model'
eof
