#---------------
# load map and select
#---------------
load 4opi.pdb
select GRG502, chain A and resi 502
#show cartoon,
show sticks, GRG502
hide lines
hide nonbonded,
bg_color white
center GRG502
#---------------
# map settings
#---------------
set mesh_width,0.35
set mesh_radius,0.001 #0.012
#---------------
# performance           
#---------------
set direct,1.
set orthoscopic,on
set ray_trace_fog_start,0.5
util.performance(0)
util.ray_shadows('light')
cmd.space('cmyk')
set antialias,on
#---------------
# load maps and draw mesh
#---------------
load 4opi_polder_map_coeffs_1.ccp4
load 4opi_polder_map_coeffs_2.ccp4
isomesh polder, 4opi_polder_map_coeffs_1, 3.0, GRG502, carve=8
isomesh polder_neg, 4opi_polder_map_coeffs_1, -3.0, GRG502, carve=8
cmd.color(22,"polder")
cmd.color(4,"polder_neg")
isomesh omit, 4opi_polder_map_coeffs_2, 3.0, GRG502, carve=8
isomesh omit_neg, 4opi_polder_map_coeffs_2, -3.0, GRG502, carve=8
cmd.color(22,"omit")
cmd.color(4,"omit_neg")
isomesh omit_low, 4opi_polder_map_coeffs_2, 1.5, GRG502, carve=8
isomesh omit_low_neg, 4opi_polder_map_coeffs_2, -1.5, GRG502, carve=8
cmd.color(22,"omit_low")
cmd.color(4,"omit_low_neg")
# get orientation
set_view (\
     0.984958708,    0.129876107,    0.113943435,\
    -0.021690041,   -0.561313272,    0.827314138,\
     0.171406433,   -0.817343295,   -0.550055861,\
     0.000202052,   -0.000009604,  -55.135562897,\
   -21.996053696,   22.201936722,  -23.467433929,\
    46.831817627,   63.378967285,  -20.000000000 )
