#!/bin/csh -f
echo "Running MR with domain 2 of 2we8"
echo "Must be run in a directory with only the starting files present"

phenix.automr coords=2we8a_al_a_domain_2.pdb copies=2 seq_file=pc0265.fasta   \
input_seq_file=pc0265.fasta identity=20 resolution=3 data=pc0265_data.mtz   \
build=False overlap_allowed=300 selection_criteria_rot_value=50   \
all_plausible_sg=False

cp AutoMR_run_1_/MR.1.pdb  2we8a_al_a_domain_2_two_copies_placed.pdb
#
echo "Running MR with domain 1 of 2we8 using fixed domain 2"
#
phenix.automr automr_placed_domain2_al.eff
#
cp  AutoMR_run_2_/MR.1.pdb four_copies.pdb

foreach x (A B C D)
phenix.pdbtools four_copies.pdb keep="chain $x" 
cp four_copies.pdb_modified.pdb $x.pdb
cat $x.pdb|grep ' CA ' |tail -1 > ${x}_ca.pdb
end

phenix.map_to_object fixed_pdb= C_ca.pdb moving_pdb=B.pdb use_moving_center_of_mass=False
phenix.map_to_object fixed_pdb= D_ca.pdb moving_pdb=A.pdb use_moving_center_of_mass=False
#  now chains AD are molecule 1 and BC are molecule 2. N-terminal domains are CD
ex A_near_D_ca.pdb<<EOD
1,%s/ A / D /
write A_near_D_ca.pdb
quit
EOD
ex B_near_C_ca.pdb<<EOD
1,%s/ B / C /
write B_near_C_ca.pdb
quit
EOD

#
head -4 A.pdb > two_chains.pdb
cat D.pdb A_near_D_ca.pdb C.pdb B_near_C_ca.pdb|grep ATOM >> two_chains.pdb

phenix.autobuild rebuild_in_place=False model=two_chains.pdb data=pc0265_data.mtz seq_file=pc0265.fasta  ncs_copies=2 nproc=4

echo "Running mr_rosetta on pc0265 complete template two_chains.pdb from 2we8"
phenix.mr_rosetta \
  seq_file=pc0265.fasta \
  data=pc0265_data.mtz \
  search_models=two_chains.pdb \
  model_already_placed=True \
  alignment_files=two_chains.ali \
  fragment_files=aaPC02_03_05.200_v1_3.gz \
  fragment_files=aaPC02_09_05.200_v1_3.gz \
  rescore_mr.relax=False \
  rosetta_models=20 \
  ncs_copies=2 \
  space_group=p43212 \
  use_all_plausible_sg=False \
  nproc=20 \
  group_run_command=qsub 
